<?php
require_once('../includes/config.php');
$current_page = 'users';
$page_title = 'Quản lý khách hàng';

$users = $conn->query("SELECT u.*, COUNT(o.id) as total_orders, SUM(o.total_price) as total_spent
                      FROM users u
                      LEFT JOIN orders o ON u.telegram_id = o.user_id
                      GROUP BY u.id
                      ORDER BY u.registered_at DESC");

include('../includes/header.php');
?>

<div class="page-header">
    <h2><i class="bi bi-people"></i> Quản lý khách hàng</h2>
</div>

<div class="card">
    <div class="card-header">
        <i class="bi bi-person-lines-fill"></i> Danh sách khách hàng
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Telegram ID</th>
                        <th>Tên</th>
                        <th>Username</th>
                        <th>Số đơn hàng</th>
                        <th>Tổng chi tiêu</th>
                        <th>Ngày đăng ký</th>
                        <th>Thao tác</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    if($users && $users->num_rows > 0) {
                        while($user = $users->fetch_assoc()): 
                    ?>
                    <tr>
                        <td><strong>#<?= $user['id'] ?></strong></td>
                        <td><code><?= $user['telegram_id'] ?></code></td>
                        <td><?= htmlspecialchars($user['first_name']) ?></td>
                        <td>
                            <?php if($user['username']): ?>
                                @<?= htmlspecialchars($user['username']) ?>
                            <?php else: ?>
                                <span class="text-muted">-</span>
                            <?php endif; ?>
                        </td>
                        <td><span class="badge bg-primary"><?= $user['total_orders'] ?></span></td>
                        <td><strong><?= number_format($user['total_spent'] ?? 0) ?>đ</strong></td>
                        <td><?= date('d/m/Y H:i', strtotime($user['registered_at'])) ?></td>
                        <td>
                            <a href="user_detail.php?id=<?= $user['telegram_id'] ?>" class="btn btn-sm btn-info">
                                <i class="bi bi-eye"></i>
                            </a>
                        </td>
                    </tr>
                    <?php 
                        endwhile;
                    } else {
                        echo "<tr><td colspan='8' class='text-center text-muted py-4'>Chưa có khách hàng nào</td></tr>";
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Thống kê khách hàng -->
<div class="row mt-4">
    <div class="col-md-4">
        <div class="card text-white" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
            <div class="card-body">
                <h6><i class="bi bi-people-fill"></i> Tổng khách hàng</h6>
                <h2><?= $users->num_rows ?></h2>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card text-white" style="background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);">
            <div class="card-body">
                <h6><i class="bi bi-cart-check-fill"></i> Khách đã mua hàng</h6>
                <h2>
                    <?php
                    $active_users = $conn->query("SELECT COUNT(DISTINCT user_id) as count FROM orders")->fetch_assoc();
                    echo $active_users['count'];
                    ?>
                </h2>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card text-white" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
            <div class="card-body">
                <h6><i class="bi bi-clock-history"></i> Khách mới (7 ngày)</h6>
                <h2>
                    <?php
                    $new_users = $conn->query("SELECT COUNT(*) as count FROM users WHERE registered_at >= DATE_SUB(NOW(), INTERVAL 7 DAY)")->fetch_assoc();
                    echo $new_users['count'];
                    ?>
                </h2>
            </div>
        </div>
    </div>
</div>

<?php include('../includes/footer.php'); ?>
