<?php
require_once('../includes/config.php');
$current_page = 'settings';
$page_title = 'Cài đặt hệ thống';

if(isset($_SESSION['message'])) {
    $message = $_SESSION['message'];
    unset($_SESSION['message']);
}

// Lấy thống kê database
$db_size = $conn->query("SELECT ROUND(SUM(data_length + index_length) / 1024 / 1024, 2) AS size 
                        FROM information_schema.TABLES 
                        WHERE table_schema = '$dbname'")->fetch_assoc();

include('../includes/header.php');
?>

<div class="page-header">
    <h2><i class="bi bi-gear"></i> Cài đặt hệ thống</h2>
</div>

<?php if(isset($message)) echo $message; ?>

<div class="row">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <i class="bi bi-database"></i> Thông tin Database
            </div>
            <div class="card-body">
                <table class="table table-borderless">
                    <tr>
                        <td><strong>Database:</strong></td>
                        <td><?= $dbname ?></td>
                    </tr>
                    <tr>
                        <td><strong>Kích thước:</strong></td>
                        <td><?= $db_size['size'] ?> MB</td>
                    </tr>
                    <tr>
                        <td><strong>Sản phẩm:</strong></td>
                        <td><?= $conn->query("SELECT COUNT(*) as c FROM products")->fetch_assoc()['c'] ?> sản phẩm</td>
                    </tr>
                    <tr>
                        <td><strong>Tài khoản:</strong></td>
                        <td><?= $conn->query("SELECT COUNT(*) as c FROM product_accounts")->fetch_assoc()['c'] ?> tài khoản</td>
                    </tr>
                    <tr>
                        <td><strong>Đơn hàng:</strong></td>
                        <td><?= $conn->query("SELECT COUNT(*) as c FROM orders")->fetch_assoc()['c'] ?> đơn</td>
                    </tr>
                    <tr>
                        <td><strong>Khách hàng:</strong></td>
                        <td><?= $conn->query("SELECT COUNT(*) as c FROM users")->fetch_assoc()['c'] ?> người</td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <i class="bi bi-tools"></i> Công cụ quản trị
            </div>
            <div class="card-body">
                <div class="d-grid gap-3">
                    <a href="backup_db.php" class="btn btn-primary">
                        <i class="bi bi-download"></i> Sao lưu Database
                    </a>
                    <a href="clear_logs.php" class="btn btn-warning" onclick="return confirm('Xác nhận xóa tất cả logs?')">
                        <i class="bi bi-trash"></i> Xóa tất cả Logs
                    </a>
                    <a href="optimize_db.php" class="btn btn-info">
                        <i class="bi bi-speedometer2"></i> Tối ưu Database
                    </a>
                    <button class="btn btn-danger" onclick="if(confirm('Xác nhận xóa TẤT CẢ dữ liệu?')) location.href='reset_db.php'">
                        <i class="bi bi-exclamation-triangle"></i> Reset Database
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row mt-4">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <i class="bi bi-info-circle"></i> Thông tin hệ thống
            </div>
            <div class="card-body">
                <table class="table">
                    <tr>
                        <td width="30%"><strong>PHP Version:</strong></td>
                        <td><?= phpversion() ?></td>
                    </tr>
                    <tr>
                        <td><strong>MySQL Version:</strong></td>
                        <td><?= $conn->server_info ?></td>
                    </tr>
                    <tr>
                        <td><strong>Server:</strong></td>
                        <td><?= $_SERVER['SERVER_SOFTWARE'] ?></td>
                    </tr>
                    <tr>
                        <td><strong>Thư mục gốc:</strong></td>
                        <td><?= $_SERVER['DOCUMENT_ROOT'] ?></td>
                    </tr>
                    <tr>
                        <td><strong>IP Server:</strong></td>
                        <td><?= $_SERVER['SERVER_ADDR'] ?></td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include('../includes/footer.php'); ?>
