<?php
require_once('../includes/config.php');

// Xác nhận reset database
if(!isset($_GET['confirm']) || $_GET['confirm'] != 'yes') {
    ?>
    <!DOCTYPE html>
    <html lang="vi">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Xác nhận Reset Database</title>
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    </head>
    <body class="bg-light">
        <div class="container">
            <div class="row justify-content-center" style="margin-top: 100px;">
                <div class="col-md-6">
                    <div class="card shadow">
                        <div class="card-header bg-danger text-white">
                            <h4 class="mb-0"><i class="bi bi-exclamation-triangle-fill"></i> Cảnh báo!</h4>
                        </div>
                        <div class="card-body">
                            <div class="alert alert-danger">
                                <h5>Bạn có chắc muốn RESET DATABASE?</h5>
                                <p class="mb-0">Hành động này sẽ:</p>
                                <ul class="mt-2">
                                    <li>Xóa TẤT CẢ sản phẩm</li>
                                    <li>Xóa TẤT CẢ tài khoản</li>
                                    <li>Xóa TẤT CẢ đơn hàng</li>
                                    <li>Xóa TẤT CẢ khách hàng</li>
                                    <li>Xóa TẤT CẢ nhật ký</li>
                                </ul>
                                <p class="text-danger fw-bold mb-0">⚠️ KHÔNG THỂ KHÔI PHỤC!</p>
                            </div>
                            
                            <div class="d-flex gap-2 justify-content-end">
                                <a href="settings.php" class="btn btn-secondary">
                                    <i class="bi bi-x-circle"></i> Hủy
                                </a>
                                <a href="reset_db.php?confirm=yes" class="btn btn-danger">
                                    <i class="bi bi-trash"></i> Xác nhận Reset
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    </body>
    </html>
    <?php
    exit();
}

// Thực hiện reset
try {
    // Tắt foreign key checks
    $conn->query("SET FOREIGN_KEY_CHECKS = 0");
    
    // Xóa dữ liệu từng bảng
    $conn->query("TRUNCATE TABLE orders");
    $conn->query("TRUNCATE TABLE product_accounts");
    $conn->query("TRUNCATE TABLE products");
    $conn->query("TRUNCATE TABLE users");
    $conn->query("TRUNCATE TABLE activity_logs");
    
    // Bật lại foreign key checks
    $conn->query("SET FOREIGN_KEY_CHECKS = 1");
    
    writeLog(0, 'RESET_DB', 'Reset toàn bộ database');
    $_SESSION['message'] = showAlert('✅ Đã reset database thành công! Tất cả dữ liệu đã bị xóa.', 'success');
    
} catch (Exception $e) {
    $_SESSION['message'] = showAlert('❌ Lỗi: ' . $e->getMessage(), 'danger');
}

header('Location: settings.php');
exit();
?>
