<?php
require_once('../includes/config.php');
$current_page = 'logs';
$page_title = 'Nhật ký hoạt động';

// Tạo bảng logs nếu chưa có
$conn->query("CREATE TABLE IF NOT EXISTS activity_logs (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id BIGINT,
    action VARCHAR(255),
    details TEXT,
    ip_address VARCHAR(50),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_created_at (created_at),
    INDEX idx_user_id (user_id)
)");

// Lấy logs
$logs = $conn->query("SELECT * FROM activity_logs ORDER BY created_at DESC LIMIT 200");

include('../includes/header.php');
?>

<div class="page-header">
    <h2><i class="bi bi-file-text"></i> Nhật ký hoạt động</h2>
    <button class="btn btn-danger" onclick="if(confirm('Xác nhận xóa tất cả nhật ký?')) location.href='clear_logs.php'">
        <i class="bi bi-trash"></i> Xóa tất cả log
    </button>
</div>

<div class="card">
    <div class="card-header">
        <i class="bi bi-clock-history"></i> Lịch sử hoạt động hệ thống
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>User ID</th>
                        <th>Hành động</th>
                        <th>Chi tiết</th>
                        <th>IP Address</th>
                        <th>Thời gian</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    if($logs && $logs->num_rows > 0) {
                        while($log = $logs->fetch_assoc()) {
                            // Màu badge theo loại action
                            $badge_color = 'info';
                            if(strpos($log['action'], 'DELETE') !== false) {
                                $badge_color = 'danger';
                            } elseif(strpos($log['action'], 'ADD') !== false) {
                                $badge_color = 'success';
                            } elseif(strpos($log['action'], 'EDIT') !== false) {
                                $badge_color = 'warning';
                            }
                    ?>
                    <tr>
                        <td><strong>#<?= $log['id'] ?></strong></td>
                        <td><?= $log['user_id'] ? $log['user_id'] : '<span class="text-muted">Admin</span>' ?></td>
                        <td><span class="badge bg-<?= $badge_color ?>"><?= htmlspecialchars($log['action']) ?></span></td>
                        <td><?= htmlspecialchars($log['details']) ?></td>
                        <td><code><?= htmlspecialchars($log['ip_address']) ?></code></td>
                        <td><?= date('d/m/Y H:i:s', strtotime($log['created_at'])) ?></td>
                    </tr>
                    <?php 
                        }
                    } else {
                        echo "<tr><td colspan='6' class='text-center text-muted py-4'>Chưa có hoạt động nào được ghi lại</td></tr>";
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Thống kê logs -->
<div class="row mt-4">
    <div class="col-md-3">
        <div class="card">
            <div class="card-body text-center">
                <i class="bi bi-plus-circle text-success" style="font-size: 2rem;"></i>
                <h4 class="mt-2">
                    <?php
                    $add_count = $conn->query("SELECT COUNT(*) as count FROM activity_logs WHERE action LIKE '%ADD%'")->fetch_assoc();
                    echo $add_count['count'];
                    ?>
                </h4>
                <p class="text-muted mb-0">Thêm mới</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card">
            <div class="card-body text-center">
                <i class="bi bi-pencil text-warning" style="font-size: 2rem;"></i>
                <h4 class="mt-2">
                    <?php
                    $edit_count = $conn->query("SELECT COUNT(*) as count FROM activity_logs WHERE action LIKE '%EDIT%'")->fetch_assoc();
                    echo $edit_count['count'];
                    ?>
                </h4>
                <p class="text-muted mb-0">Chỉnh sửa</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card">
            <div class="card-body text-center">
                <i class="bi bi-trash text-danger" style="font-size: 2rem;"></i>
                <h4 class="mt-2">
                    <?php
                    $delete_count = $conn->query("SELECT COUNT(*) as count FROM activity_logs WHERE action LIKE '%DELETE%'")->fetch_assoc();
                    echo $delete_count['count'];
                    ?>
                </h4>
                <p class="text-muted mb-0">Xóa</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card">
            <div class="card-body text-center">
                <i class="bi bi-activity text-info" style="font-size: 2rem;"></i>
                <h4 class="mt-2">
                    <?php
                    $total_count = $conn->query("SELECT COUNT(*) as count FROM activity_logs")->fetch_assoc();
                    echo $total_count['count'];
                    ?>
                </h4>
                <p class="text-muted mb-0">Tổng hoạt động</p>
            </div>
        </div>
    </div>
</div>

<?php include('../includes/footer.php'); ?>
