<?php
require_once('../includes/config.php');

$product_id = intval($_GET['product_id'] ?? 0);

if($product_id > 0) {
    $accounts = $conn->query("SELECT * FROM product_accounts 
                             WHERE product_id = $product_id 
                             ORDER BY is_sold ASC, id DESC");
    
    if($accounts && $accounts->num_rows > 0) {
        echo '<div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th width="80">ID</th>
                            <th>Thông tin tài khoản</th>
                            <th width="120">Trạng thái</th>
                            <th>Người mua</th>
                            <th>Ngày bán</th>
                            <th width="100">Thao tác</th>
                        </tr>
                    </thead>
                    <tbody>';
        
        while($acc = $accounts->fetch_assoc()) {
            $rowClass = $acc['is_sold'] ? 'table-secondary' : '';
            $status = $acc['is_sold'] ? '<span class="badge bg-danger">Đã bán</span>' : '<span class="badge bg-success">Còn hàng</span>';
            $soldTo = $acc['sold_to_user_id'] ?? '-';
            $soldAt = $acc['sold_at'] ? date('d/m/Y H:i', strtotime($acc['sold_at'])) : '-';
            
            $deleteBtn = !$acc['is_sold'] 
                ? '<a href="delete_account.php?id=' . $acc['id'] . '" 
                      class="btn btn-sm btn-danger" 
                      onclick="return confirm(\'Xác nhận xóa?\')">
                      <i class="bi bi-trash"></i>
                   </a>' 
                : '<span class="text-muted">-</span>';
            
            echo "<tr class='$rowClass'>
                    <td><strong>#" . $acc['id'] . "</strong></td>
                    <td><code>" . htmlspecialchars($acc['account_data']) . "</code></td>
                    <td>$status</td>
                    <td>$soldTo</td>
                    <td>$soldAt</td>
                    <td>$deleteBtn</td>
                  </tr>";
        }
        
        echo '</tbody></table></div>';
        
        // Thống kê
        $total = $accounts->num_rows;
        $sold = $conn->query("SELECT COUNT(*) as c FROM product_accounts WHERE product_id = $product_id AND is_sold = 1")->fetch_assoc()['c'];
        $available = $total - $sold;
        
        echo '<div class="row text-center mt-3">
                <div class="col-4">
                    <h4 class="text-primary">' . $total . '</h4>
                    <small class="text-muted">Tổng số</small>
                </div>
                <div class="col-4">
                    <h4 class="text-success">' . $available . '</h4>
                    <small class="text-muted">Còn lại</small>
                </div>
                <div class="col-4">
                    <h4 class="text-danger">' . $sold . '</h4>
                    <small class="text-muted">Đã bán</small>
                </div>
              </div>';
    } else {
        echo '<div class="alert alert-info">
                <i class="bi bi-info-circle"></i> Chưa có tài khoản nào cho sản phẩm này.
              </div>';
    }
} else {
    echo '<div class="alert alert-danger">ID sản phẩm không hợp lệ!</div>';
}
?>
