<?php
require_once('../includes/config.php');
$current_page = 'products';
$page_title = 'Chỉnh sửa sản phẩm';

if(!isset($_GET['id'])) {
    header('Location: products.php');
    exit();
}

$id = intval($_GET['id']);

// Xử lý form submit
if($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name = $conn->real_escape_string($_POST['name']);
    $description = $conn->real_escape_string($_POST['description']);
    $price = floatval($_POST['price']);
    $category = $conn->real_escape_string($_POST['category']);
    
    $sql = "UPDATE products SET 
            name = '$name', 
            description = '$description', 
            price = $price, 
            category = '$category' 
            WHERE id = $id";
    
    if($conn->query($sql)) {
        writeLog(0, 'EDIT_PRODUCT', "Sửa sản phẩm ID: $id - $name");
        $_SESSION['message'] = showAlert('Cập nhật sản phẩm thành công!', 'success');
        header('Location: products.php');
        exit();
    } else {
        $_SESSION['message'] = showAlert('Lỗi: ' . $conn->error, 'danger');
    }
}

// Lấy thông tin sản phẩm
$product = $conn->query("SELECT * FROM products WHERE id = $id")->fetch_assoc();

if(!$product) {
    $_SESSION['message'] = showAlert('Không tìm thấy sản phẩm!', 'danger');
    header('Location: products.php');
    exit();
}

include('../includes/header.php');
?>

<div class="page-header">
    <h2><i class="bi bi-pencil"></i> Chỉnh sửa sản phẩm</h2>
    <a href="products.php" class="btn btn-secondary">
        <i class="bi bi-arrow-left"></i> Quay lại
    </a>
</div>

<div class="row">
    <div class="col-md-8 mx-auto">
        <div class="card">
            <div class="card-header">
                <i class="bi bi-box-seam"></i> Thông tin sản phẩm #<?= $id ?>
            </div>
            <div class="card-body">
                <form method="POST">
                    <div class="mb-3">
                        <label class="form-label">Tên sản phẩm *</label>
                        <input type="text" class="form-control" name="name" value="<?= htmlspecialchars($product['name']) ?>" required>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Mô tả</label>
                        <textarea class="form-control" name="description" rows="4"><?= htmlspecialchars($product['description']) ?></textarea>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Giá (VNĐ) *</label>
                                <input type="number" class="form-control" name="price" value="<?= $product['price'] ?>" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Danh mục *</label>
                                <select class="form-select" name="category" required>
                                    <option value="AI" <?= $product['category'] == 'AI' ? 'selected' : '' ?>>AI</option>
                                    <option value="Streaming" <?= $product['category'] == 'Streaming' ? 'selected' : '' ?>>Streaming</option>
                                    <option value="Music" <?= $product['category'] == 'Music' ? 'selected' : '' ?>>Music</option>
                                    <option value="Gaming" <?= $product['category'] == 'Gaming' ? 'selected' : '' ?>>Gaming</option>
                                    <option value="Other" <?= $product['category'] == 'Other' ? 'selected' : '' ?>>Khác</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="d-flex justify-content-between">
                        <a href="products.php" class="btn btn-secondary">
                            <i class="bi bi-x-circle"></i> Hủy
                        </a>
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-check-circle"></i> Cập nhật
                        </button>
                    </div>
                </form>
            </div>
        </div>
        
        <!-- Thống kê sản phẩm -->
        <div class="card mt-3">
            <div class="card-header">
                <i class="bi bi-bar-chart"></i> Thống kê sản phẩm
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="text-center">
                            <h4 class="text-primary">
                                <?php
                                $stock = $conn->query("SELECT COUNT(*) as count FROM product_accounts WHERE product_id = $id AND is_sold = 0")->fetch_assoc();
                                echo $stock['count'];
                                ?>
                            </h4>
                            <p class="text-muted mb-0">Tài khoản còn lại</p>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="text-center">
                            <h4 class="text-success">
                                <?php
                                $sold = $conn->query("SELECT COUNT(*) as count FROM product_accounts WHERE product_id = $id AND is_sold = 1")->fetch_assoc();
                                echo $sold['count'];
                                ?>
                            </h4>
                            <p class="text-muted mb-0">Đã bán</p>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="text-center">
                            <h4 class="text-info">
                                <?php
                                $revenue = $conn->query("SELECT SUM(total_price) as total FROM orders WHERE product_id = $id")->fetch_assoc();
                                echo number_format($revenue['total'] ?? 0);
                                ?>đ
                            </h4>
                            <p class="text-muted mb-0">Doanh thu</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include('../includes/footer.php'); ?>
