<?php
require_once('../includes/config.php');

if(isset($_GET['id'])) {
    $id = intval($_GET['id']);
    
    // Kiểm tra xem sản phẩm có tồn tại không
    $product = $conn->query("SELECT name FROM products WHERE id = $id");
    
    if($product && $product->num_rows > 0) {
        $product_data = $product->fetch_assoc();
        $product_name = $product_data['name'];
        
        // Kiểm tra xem có đơn hàng nào liên quan không
        $order_check = $conn->query("SELECT COUNT(*) as count FROM orders WHERE product_id = $id");
        $order_count = $order_check->fetch_assoc()['count'];
        
        if($order_count > 0) {
            // Có đơn hàng - không cho xóa
            $_SESSION['message'] = showAlert(
                "Không thể xóa sản phẩm '$product_name' vì đã có $order_count đơn hàng liên quan! <br>
                 Bạn có thể xóa tất cả tài khoản của sản phẩm này thay vì xóa sản phẩm.", 
                'warning'
            );
        } else {
            // Không có đơn hàng - cho phép xóa
            // Xóa tài khoản liên quan trước
            $conn->query("DELETE FROM product_accounts WHERE product_id = $id");
            
            // Xóa sản phẩm
            if($conn->query("DELETE FROM products WHERE id = $id")) {
                writeLog(0, 'DELETE_PRODUCT', "Xóa sản phẩm: $product_name (ID: $id)");
                $_SESSION['message'] = showAlert('Xóa sản phẩm thành công!', 'success');
            } else {
                $_SESSION['message'] = showAlert('Lỗi: ' . $conn->error, 'danger');
            }
        }
        
    } else {
        $_SESSION['message'] = showAlert('Không tìm thấy sản phẩm!', 'warning');
    }
} else {
    $_SESSION['message'] = showAlert('ID sản phẩm không hợp lệ!', 'danger');
}

header('Location: products.php');
exit();
?>
