<?php
require_once('../includes/config.php');

// Tên file backup
$backup_file = 'backup_' . date('Y-m-d_H-i-s') . '.sql';
$backup_path = '../backups/';

// Tạo thư mục backup nếu chưa có
if(!file_exists($backup_path)) {
    mkdir($backup_path, 0777, true);
}

// Lấy danh sách bảng
$tables = [];
$result = $conn->query("SHOW TABLES");
while($row = $result->fetch_array()) {
    $tables[] = $row[0];
}

// Nội dung backup
$backup_content = "";
$backup_content .= "-- Database Backup\n";
$backup_content .= "-- Date: " . date('Y-m-d H:i:s') . "\n";
$backup_content .= "-- Database: {$dbname}\n\n";

foreach($tables as $table) {
    // Drop table
    $backup_content .= "DROP TABLE IF EXISTS `{$table}`;\n\n";
    
    // Create table
    $create_table = $conn->query("SHOW CREATE TABLE `{$table}`")->fetch_array();
    $backup_content .= $create_table[1] . ";\n\n";
    
    // Insert data
    $rows = $conn->query("SELECT * FROM `{$table}`");
    if($rows && $rows->num_rows > 0) {
        while($row = $rows->fetch_assoc()) {
            $columns = array_keys($row);
            $values = array_map(function($value) use ($conn) {
                return is_null($value) ? 'NULL' : "'" . $conn->real_escape_string($value) . "'";
            }, array_values($row));
            
            $backup_content .= "INSERT INTO `{$table}` (`" . implode('`, `', $columns) . "`) VALUES (" . implode(', ', $values) . ");\n";
        }
        $backup_content .= "\n";
    }
}

// Lưu file
$full_path = $backup_path . $backup_file;
if(file_put_contents($full_path, $backup_content)) {
    writeLog(0, 'BACKUP_DB', "Sao lưu database: $backup_file");
    
    // Download file
    header('Content-Type: application/octet-stream');
    header('Content-Disposition: attachment; filename="' . $backup_file . '"');
    header('Content-Length: ' . filesize($full_path));
    readfile($full_path);
    
    // Xóa file sau khi download (tùy chọn)
    // unlink($full_path);
    
    exit();
} else {
    $_SESSION['message'] = showAlert('Lỗi khi tạo file backup!', 'danger');
    header('Location: settings.php');
    exit();
}
?>
