<?php
require_once('../includes/config.php');
$current_page = 'accounts';
$page_title = 'Quản lý kho tài khoản';

if(isset($_SESSION['message'])) {
    $message = $_SESSION['message'];
    unset($_SESSION['message']);
}

$products = $conn->query("SELECT * FROM products ORDER BY name");
$accounts = $conn->query("SELECT pa.*, p.name as product_name 
                         FROM product_accounts pa 
                         JOIN products p ON pa.product_id = p.id 
                         ORDER BY pa.is_sold ASC, pa.id DESC");

include('../includes/header.php');
?>

<div class="page-header">
    <h2><i class="bi bi-key"></i> Quản lý kho tài khoản</h2>
    <div>
        <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#bulkAddModal">
            <i class="bi bi-file-earmark-text"></i> Upload File TXT
        </button>
        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addAccountModal">
            <i class="bi bi-plus-circle"></i> Thêm 1 tài khoản
        </button>
    </div>
</div>

<?php if(isset($message)) echo $message; ?>

<div class="card">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Sản phẩm</th>
                        <th>Thông tin tài khoản</th>
                        <th>Trạng thái</th>
                        <th>Người mua</th>
                        <th>Ngày bán</th>
                        <th>Thao tác</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    if($accounts && $accounts->num_rows > 0) {
                        while($acc = $accounts->fetch_assoc()): 
                    ?>
                    <tr class="<?= $acc['is_sold'] ? 'table-secondary' : '' ?>">
                        <td><strong>#<?= $acc['id'] ?></strong></td>
                        <td><?= htmlspecialchars($acc['product_name']) ?></td>
                        <td><code><?= htmlspecialchars($acc['account_data']) ?></code></td>
                        <td>
                            <?php if($acc['is_sold']): ?>
                                <span class="badge bg-danger">Đã bán</span>
                            <?php else: ?>
                                <span class="badge bg-success">Còn hàng</span>
                            <?php endif; ?>
                        </td>
                        <td><?= $acc['sold_to_user_id'] ?? '-' ?></td>
                        <td><?= $acc['sold_at'] ? date('d/m/Y H:i', strtotime($acc['sold_at'])) : '-' ?></td>
                        <td>
                            <?php if(!$acc['is_sold']): ?>
                            <a href="delete_account.php?id=<?= $acc['id'] ?>" 
                               class="btn btn-sm btn-danger"
                               onclick="return confirm('Xác nhận xóa tài khoản này?')">
                                <i class="bi bi-trash"></i>
                            </a>
                            <?php else: ?>
                                <span class="text-muted">-</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php 
                        endwhile;
                    } else {
                        echo "<tr><td colspan='7' class='text-center text-muted py-4'>Chưa có tài khoản nào</td></tr>";
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Modal Thêm 1 Tài Khoản -->
<div class="modal fade" id="addAccountModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="bi bi-plus-circle"></i> Thêm tài khoản mới</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="add_account.php">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Chọn sản phẩm *</label>
                        <select class="form-select" name="product_id" required>
                            <option value="">-- Chọn sản phẩm --</option>
                            <?php 
                            $products->data_seek(0);
                            while($p = $products->fetch_assoc()): 
                            ?>
                            <option value="<?= $p['id'] ?>"><?= htmlspecialchars($p['name']) ?></option>
                            <?php endwhile; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Thông tin tài khoản *</label>
                        <input type="text" class="form-control" name="account_data" 
                               placeholder="email@example.com|password123" required>
                        <small class="text-muted">Format: email|password</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Hủy</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-circle"></i> Thêm tài khoản
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Upload File TXT -->
<div class="modal fade" id="bulkAddModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title"><i class="bi bi-file-earmark-arrow-up"></i> Thêm hàng loạt từ file TXT</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="bulk_add_accounts.php" enctype="multipart/form-data">
                <div class="modal-body">
                    <div class="alert alert-info">
                        <i class="bi bi-info-circle"></i> <strong>Hướng dẫn:</strong>
                        <ul class="mb-0 mt-2">
                            <li>Mỗi dòng trong file là 1 tài khoản</li>
                            <li>Format: <code>email|password</code> hoặc <code>username|password</code></li>
                            <li>Ví dụ: <code>user1@gmail.com|pass123</code></li>
                        </ul>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Chọn sản phẩm *</label>
                        <select class="form-select" name="product_id" required>
                            <option value="">-- Chọn sản phẩm --</option>
                            <?php 
                            $products->data_seek(0);
                            while($p = $products->fetch_assoc()): 
                            ?>
                            <option value="<?= $p['id'] ?>"><?= htmlspecialchars($p['name']) ?> (<?= number_format($p['price']) ?>đ)</option>
                            <?php endwhile; ?>
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Chọn file TXT *</label>
                        <input type="file" class="form-control" name="accounts_file" accept=".txt" required>
                        <small class="text-muted">Chỉ chấp nhận file .txt</small>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Hoặc dán nội dung vào đây:</label>
                        <textarea class="form-control" name="accounts_text" rows="8" 
                                  placeholder="email1@example.com|password1&#10;email2@example.com|password2&#10;email3@example.com|password3"></textarea>
                        <small class="text-muted">Mỗi dòng là 1 tài khoản</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Hủy</button>
                    <button type="submit" class="btn btn-success">
                        <i class="bi bi-upload"></i> Upload & Thêm tài khoản
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php include('../includes/footer.php'); ?>
